/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_05; import java.io.*; import javax.servlet.http.*; 
import org.omg.CORBA.ORB; import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class DominoServletConPoolOneUser extends HttpServlet {

	private static ORB brooker = null;
	private static int orbCount = 0;
	private static String token = null;
	private static final String host = "www.djbuch.de:63148";
	private static final int MAX_SESSION_IN_POOL = 10;

	/**
	 * Connection Pooling Servlet <br>
	 * Baut initial mit einem Funktionsuser eine Session auf, <br>
	 * um ein LtpaToken zu beziehen. <br>
	 * Alle weiteren Aufrufe werden mit diesem Token realisiert. <br>
	 * Arbeitet zustzlich mit Connection Pooling.
	 */
	public void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws IOException {
		Session session = null;
		try {
			PrintWriter out = resp.getWriter();
			resp.setContentType("text/html"); 
			out.println ("<html><head>\n" +
					"<title>Domino Servlet</title>\n<style>\n" +
					"\tbody {font-family:Helvetica,Arial,sans-serif;}\n" +
					"\th1 {color:#FF00FF;}\n</style>\n</head>\n" +
					"<body>\n<h1>Connection Pooling Servlet</h1>\n");
			out.println((token==null)?"<br/>New Session":"<br/>Token = " + token);
			session = getSession();
			out.println("<br/>Name = " + session.getUserName());
			out.println("<br/>Count = " + orbCount);
			out.println("</body></html>");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			recycleSession(session);
		}
	}

	/**
	 * @return - Liefert eine Notes Session. Fhrt einen Retry durch, falls <br>
	 * beim ersten Versuch eine NotesException auftritt. <br>
	 * @throws NotesException
	 */
	private Session getSession() throws NotesException {
		Session session = null;
		try {
			session = NotesFactory.createSession(host, getBrooker(), getToken(false));
		} catch (NotesException e) {
			System.err.println ("TOKEN INVALID OR NO SESSION AVAILABLE " + orbCount);
			session = NotesFactory.createSession(host, getBrooker(), getToken(true));			
		}
		return session;
	}

	/**
	 * @return - Liefert einen Object Request Brooker, falls mehr als 10 Sitzungen <br>
	 * offen sind, sonst den bereits erstellten, sofern vorhanden.
	 */
	private static synchronized ORB getBrooker() {
		orbCount+=1;
		if ((brooker == null) || ((orbCount % MAX_SESSION_IN_POOL) == 0)) {
			brooker = NotesFactory.createORB();
			System.out.println(brooker.getClass() + " wurde erstellt.");
		}
		return brooker;
	}
	
	/**
	 * Das LtpaToken wird, falls noch nicht vorhanden, <br>
	 * durch einen expliziten Login berechnet und dann wiederverwendet. <br>
	 * Wirft eine NotesException, falls etwas nicht klappt.
	 * @throws NotesException
	 */
	private static synchronized String getToken (boolean enforce) throws NotesException {
		if (!enforce && token != null && !token.equals ("")) {
			return token;
		} else {
			Session tempSession = null;
			try {
				tempSession = NotesFactory.createSession(host, "Administrator","geheim");
				token = tempSession.getSessionToken();
				return token;
			} finally {
				recycleSession(tempSession);
			}
		}
	}
	
	private static void recycleSession (Session s) {
		try {
			if (s!= null && s.isValid()) {
				s.recycle ();
			}
		} catch (org.omg.CORBA.INV_OBJREF e) {
			//e.printStackTrace(); //ignore. Server might already have closed DIIOP.
		} catch (NotesException e) {
			e.printStackTrace();
		}
	}
}